options(width = 120)
#*********************************************************************************#
#*                                                                                #
#* Purpose: R program to create permanent R .RDS data set                         #
#*          harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta          #
#*          with the Harmonized TUS CPS 1992 through 2019 replicate weights 95-03 #
#*                                                                                #
#*   Notes: The program uses the package readr                                    #
#                                                                                 #
#*********************************************************************************#

##############################################################################################################
# Set working directories
##############################################################################################################

setwd("//westat.com/DFS/NCIDCCPS/DCCPS - Global/Scientific Projects/TUS-CPS/Statistician/ifc/R work/prg/3. Harmonized data")
getwd()

##############################################################################################################
# Load libraries
#
library(readr)


##############################################################################################################
## Create data dictionary with varaible names, witdths, type and labels
##############################################################################################################

data_diccionary <-
'SurYear         1       4       numeric   "Survey year"
SurMonth        5       6       numeric   "Survey month"
RecordID        7       28      character "Record ID (Unique within survey month  "
SmplWgt         29      39      numeric   "Self Response Sample Weight"
RepWt001        40      50      numeric   "Replicate Weight #1"    
RepWt002        51      61      numeric   "Replicate Weight #2"    
RepWt003        62      72      numeric   "Replicate Weight #3"    
RepWt004        73      83      numeric   "Replicate Weight #4"    
RepWt005        84      94      numeric   "Replicate Weight #5"    
RepWt006        95      105     numeric   "Replicate Weight #6"    
RepWt007        106     116     numeric   "Replicate Weight #7"    
RepWt008        117     127     numeric   "Replicate Weight #8"    
RepWt009        128     138     numeric   "Replicate Weight #9"    
RepWt010        139     149     numeric   "Replicate Weight #10"    
RepWt011        150     160     numeric   "Replicate Weight #11"    
RepWt012        161     171     numeric   "Replicate Weight #12"    
RepWt013        172     182     numeric   "Replicate Weight #13"    
RepWt014        183     193     numeric   "Replicate Weight #14"    
RepWt015        194     204     numeric   "Replicate Weight #15"    
RepWt016        205     215     numeric   "Replicate Weight #16"    
RepWt017        216     226     numeric   "Replicate Weight #17"    
RepWt018        227     237     numeric   "Replicate Weight #18"    
RepWt019        238     248     numeric   "Replicate Weight #19"    
RepWt020        249     259     numeric   "Replicate Weight #20"    
RepWt021        260     270     numeric   "Replicate Weight #21"    
RepWt022        271     281     numeric   "Replicate Weight #22"    
RepWt023        282     292     numeric   "Replicate Weight #23"    
RepWt024        293     303     numeric   "Replicate Weight #24"    
RepWt025        304     314     numeric   "Replicate Weight #25"    
RepWt026        315     325     numeric   "Replicate Weight #26"    
RepWt027        326     336     numeric   "Replicate Weight #27"    
RepWt028        337     347     numeric   "Replicate Weight #28"    
RepWt029        348     358     numeric   "Replicate Weight #29"    
RepWt030        359     369     numeric   "Replicate Weight #30"    
RepWt031        370     380     numeric   "Replicate Weight #31"    
RepWt032        381     391     numeric   "Replicate Weight #32"    
RepWt033        392     402     numeric   "Replicate Weight #33"    
RepWt034        403     413     numeric   "Replicate Weight #34"    
RepWt035        414     424     numeric   "Replicate Weight #35"    
RepWt036        425     435     numeric   "Replicate Weight #36"    
RepWt037        436     446     numeric   "Replicate Weight #37"    
RepWt038        447     457     numeric   "Replicate Weight #38"    
RepWt039        458     468     numeric   "Replicate Weight #39"    
RepWt040        469     479     numeric   "Replicate Weight #40"    
RepWt041        480     490     numeric   "Replicate Weight #41"    
RepWt042        491     501     numeric   "Replicate Weight #42"    
RepWt043        502     512     numeric   "Replicate Weight #43"    
RepWt044        513     523     numeric   "Replicate Weight #44"    
RepWt045        524     534     numeric   "Replicate Weight #45"    
RepWt046        535     545     numeric   "Replicate Weight #46"    
RepWt047        546     556     numeric   "Replicate Weight #47"    
RepWt048        557     567     numeric   "Replicate Weight #48"    
RepWt049        568     578     numeric   "Replicate Weight #49"    
RepWt050        579     589     numeric   "Replicate Weight #50"    
RepWt051        590     600     numeric   "Replicate Weight #51"    
RepWt052        601     611     numeric   "Replicate Weight #52"    
RepWt053        612     622     numeric   "Replicate Weight #53"    
RepWt054        623     633     numeric   "Replicate Weight #54"    
RepWt055        634     644     numeric   "Replicate Weight #55"    
RepWt056        645     655     numeric   "Replicate Weight #56"    
RepWt057        656     666     numeric   "Replicate Weight #57"    
RepWt058        667     677     numeric   "Replicate Weight #58"    
RepWt059        678     688     numeric   "Replicate Weight #59"    
RepWt060        689     699     numeric   "Replicate Weight #60"    
RepWt061        700     710     numeric   "Replicate Weight #61"    
RepWt062        711     721     numeric   "Replicate Weight #62"    
RepWt063        722     732     numeric   "Replicate Weight #63"    
RepWt064        733     743     numeric   "Replicate Weight #64"    
RepWt065        744     754     numeric   "Replicate Weight #65"    
RepWt066        755     765     numeric   "Replicate Weight #66"    
RepWt067        766     776     numeric   "Replicate Weight #67"    
RepWt068        777     787     numeric   "Replicate Weight #68"    
RepWt069        788     798     numeric   "Replicate Weight #69"    
RepWt070        799     809     numeric   "Replicate Weight #70"    
RepWt071        810     820     numeric   "Replicate Weight #71"    
RepWt072        821     831     numeric   "Replicate Weight #72"    
RepWt073        832     842     numeric   "Replicate Weight #73"    
RepWt074        843     853     numeric   "Replicate Weight #74"    
RepWt075        854     864     numeric   "Replicate Weight #75"    
RepWt076        865     875     numeric   "Replicate Weight #76"    
RepWt077        876     886     numeric   "Replicate Weight #77"    
RepWt078        887     897     numeric   "Replicate Weight #78"    
RepWt079        898     908     numeric   "Replicate Weight #79"    
RepWt080        909     919     numeric   "Replicate Weight #80"' 



###############################################################################
# Location of CPS 1992 through 2019 replicate weights 95-03
###############################################################################


cps.replicate.data <- "./harmonzd.tus_cps.1992.through.2019.replicate.wgts.95_03.dat"


###############################################################################
# Create data dictionary
###############################################################################
tmp_file <- tempfile()
writeLines(data_diccionary, tmp_file)
data_diccionary_table <- read.table(tmp_file,sep="", col.names = c("variable", "initial_position","final_position", "type", "label"))

### Set varaible type numeric to "n" and characeter to "c"
levels(data_diccionary_table$type)<-c("c","n")
data_diccionary_tabletype <- as.character(data_diccionary_table$type)
### Create list for varaible name and type 
names(data_diccionary_tabletype) <-  data_diccionary_table$variable
data_diccionary_tabletype <- as.list(data_diccionary_tabletype)


###############################################################################
## Reading the CPS 1992 through 2019 replicate weights 95-03
##


harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta  <- as.data.frame(read_fwf(cps.replicate.data, 
 col_positions = fwf_positions( data_diccionary_table$initial_position, 
                 data_diccionary_table$final_position,
                  col_names= data_diccionary_table$variable),
                 col_types = data_diccionary_tabletype  )) 




###############################################################################
## Attaching labels
###############################################################################
for (i in 1:length(data_diccionary_table$variable))
{
  attr(harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta[,i],"label") <- data_diccionary_table$label[i]
}
dim(harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta)


###############################################################################
## Saving the CPS 1992 through 2019 replicate weights 95-03
###############################################################################

str(harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta, list.len=ncol(harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta))

saveRDS(harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta, file = "./harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta.RDS")


